<?php

/**
* Função para calcular o próximo dia útil de uma data
* Formato de entrada da $data: AAAA-MM-DD
*/
function calculaSla($data, $tempo, $definicao_tempo) {
include ('conexao.php');	
// Converte $data em um UNIX TIMESTAMP
echo $data;
echo '<br>';

$timestamp = strtotime($data);
// Calcula qual o dia da semana de $data
// O resultado será um valor numérico:
// 1 -> Segunda ... 7 -> Domingo
$dia = date('N', $timestamp);

// Se for sábado (6) ou domingo (7), calcula a próxima segunda-feira
	if ($dia == 7) {
		//$timestamp_final = $timestamp + ((8 - $dia) * 3600 * 24);
		$novadata = calcintervalo($data, 1, 'day');
		$timestamp = strtotime($novadata);
		$dia = date('N', $timestamp);
		$query = "SELECT `begin`, `end` FROM glpi_calendarsegments WHERE `day` = {$dia}";
		$res = mysqli_query($conn, $query);
		$row = mysqli_fetch_assoc($res);
		$inicio = $row['begin'];
		$fim = $row['end'];
		$datafinal = calculaData($novadata, $tempo, $definicao_tempo, $inicio, $fim);
		
	} elseif ($dia == 6){
		$query = "SELECT `begin`, `end` FROM glpi_calendarsegments WHERE `day` = {$dia}";
		$res = mysqli_query($conn, $query);
		$row = mysqli_fetch_assoc($res);
		$inicio = $row['begin'];
		$fim = $row['end'];
		$datafinal = calculaData($data, $tempo, $definicao_tempo, $inicio, $fim);
	} else {
	// Não é domingo, mantém a data de entrada
		$query = "SELECT `begin`, `end` FROM glpi_calendarsegments WHERE `day` = {$dia}";
		$res = mysqli_query($conn, $query);
		$row = mysqli_fetch_assoc($res);
		$inicio = $row['begin'];
		$fim = $row['end'];
		$datafinal = calculaData($data, $tempo, $definicao_tempo, $inicio, $fim);
	}

$saida = $datafinal;
return $saida;
}


function calculaData($data, $tempo, $definicao_tempo, $inicio, $fim){
	include ('conexao.php');
	if (date('H:i:s',strtotime($data)) < $inicio) {
		$dat = date('Y-m-d',strtotime($data));
		$hor = $inicio;
		$data1 = date('Y-m-d H:i:s',strtotime($dat.' '.$hor));
		$novadata = calcintervalo($data1, $tempo, $definicao_tempo);
	}elseif (date('H:i:s',strtotime($data)) >= $fim) {
		$dat = date('Y-m-d',strtotime($data));
		$hor = $inicio;
		$data1 = date('Y-m-d H:i:s',strtotime($dat.' '.$hor));
		$novadata = calcintervalo($data1, $tempo, $definicao_tempo);
		$novadata = calcintervalo($novadata, 1, 'day'); 
	}else{
		$novadata = calcintervalo($data, $tempo, $definicao_tempo);
		if (date('H:i:s',strtotime($novadata)) >= $fim) {
			$tempo1 = date('H:i:s', strtotime($novadata) - strtotime($fim));
			$dat1 = date('Y-m-d',strtotime($novadata));
			$hor = $inicio;
			$data1 = date('Y-m-d H:i:s',strtotime($dat1.' '.$hor));
			$te = explode(":",$tempo1);
			$h = $te[0];
			$m = $te[1];
			if ($h >0){
				$novadata = calcintervalo($data1, $h, 'hour');
			}else{
				$novadata = $data1;
			}
			if ($m > 0){	
				$novadata = calcintervalo($novadata, $m, 'minute'); 	
			} else {
				$novadata = $data1;
			}
			$novadata = calcintervalo($novadata, 1, 'day'); 			
		}elseif (date('H:i:s',strtotime($novadata)) < $inicio) {
			$tempo1 = date('H:i:s', strtotime('24:00:00') - strtotime($fim));
			$tempo2 = date('H:i:s', strtotime($novadata));
			$novadata = date('Y-m-d',strtotime($novadata));
			$hor = $inicio;
			$novadata = date('Y-m-d H:i:s',strtotime($novadata.' '.$hor));
			$te = explode(":",$tempo1);
			$h = $te[0];
			$m = $te[1];
			if ($h >0){
				$novadata = calcintervalo($novadata, $h, 'hour');
			}
			if ($m > 0){	
				$novadata = calcintervalo($novadata, $m, 'minute'); 	
			} 
			$te2 = explode(":",$tempo2);
			$h2 = $te2[0];
			$m2 = $te2[1];
			if ($h2 >0){
				$novadata = calcintervalo($novadata, $h2, 'hour');
			}
			if ($m2 > 0){	
				$novadata = calcintervalo($novadata, $m2, 'minute'); 	
			} 			
		} 
	}
//	$query = "SELECT * FROM glpi_holidays WHERE begin_date = '".date('Y-m-d',strtotime($novadata))."';";
//	$res = mysqli_query($conn, $query);
//	$row = mysqli_fetch_assoc($res);
//	if ($row > 0){
//		$novadata = calcintervalo($novadata, 1, 'day');
//	}
	$timestamp = strtotime($novadata);
	$dia = date('N', $timestamp);
	// Se for sábado (6) ou domingo (7), calcula a próxima segunda-feira
	if ($dia == 7) {
		$novadata = calcintervalo($novadata, 1, 'day');	
	} elseif ($dia == 6) {
		$query = "SELECT `begin`, `end` FROM glpi_calendarsegments WHERE `day` = {$dia}";
		$res = mysqli_query($conn, $query);
		$row = mysqli_fetch_assoc($res);
		$inicio1 = $row['begin'];
		$fim1 = $row['end'];
		$novadata = calculaData($novadata, $tempo, $definicao_tempo, $inicio1, $fim1);	
	}
	$query = "SELECT * FROM glpi_holidays WHERE begin_date = '".date('Y-m-d',strtotime($novadata))."';";
	$res = mysqli_query($conn, $query);
	$row = mysqli_fetch_assoc($res);
	if ($row > 0){
		$novadata = calcintervalo($novadata, 1, 'day');
	}	
	return $novadata;
}



function calcintervalo($data, $tempo, $definicao_tempo){

$novadata = new DateTime($data);

if ($definicao_tempo == 'hour'){
	$intervalo = 'PT'.$tempo.'H';
} elseif ($definicao_tempo == 'minute'){
	$intervalo = 'PT'.$tempo.'M';
} else {
	$intervalo = 'P'.$tempo.'D';
}
	
$incremento = new DateInterval($intervalo);
$novadata->add($incremento);


$novadata = date('Y-m-d H:i:s',strtotime($novadata->format('Y-m-d H:i:s')));


return $novadata;
}

?>
