//#region Funções Gerais


function hasDateInArray(value, array){
    for(var i=0; i<array.length; i++)
    {
        if(array[i].dataFormatada === value){ return i; }
    }
    return -1;
}


var waitingDialog = waitingDialog || (function ($) {
    'use strict';

	// Creating modal dialog's DOM
	var $dialog = $(
		'<div class="modal fade" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true" style="padding-top:15%; overflow-y:visible;">' +
		'<div class="modal-dialog modal-m">' +
		'<div class="modal-content">' +
			'<div class="modal-header"><h3 style="margin:0;"></h3></div>' +
			'<div class="modal-body">' +
				'<div class="progress progress-striped active" style="margin-bottom:0;"><div class="progress-bar" style="width: 100%"></div></div>' +
			'</div>' +
		'</div></div></div>');

	return {
		/**
		 * Opens our dialog
		 * @param message Custom message
		 * @param options Custom options:
		 * 				  options.dialogSize - bootstrap postfix for dialog size, e.g. "sm", "m";
		 * 				  options.progressType - bootstrap postfix for progress bar type, e.g. "success", "warning".
		 */
		show: function (message, options) {
			// Assigning defaults
			if (typeof options === 'undefined') {
				options = {};
			}
			if (typeof message === 'undefined') {
				message = 'Aguarde...';
			}
			var settings = $.extend({
				dialogSize: 'sm',
				progressType: '',
				onHide: null // This callback runs after the dialog was hidden
			}, options);

			// Configuring dialogattr
			$dialog.find('.modal-dialog').attr('class', 'modal-dialog').addClass('modal-' + settings.dialogSize);
			$dialog.find('.progress-bar').attr('class', 'progress-bar');
			if (settings.progressType) {
				$dialog.find('.progress-bar').addClass('progress-bar-' + settings.progressType);
            }
            else {
                $dialog.find('.progress-bar').addClass('progress-bar-success');
            }
			$dialog.find('h3').text(message);
			// Adding callbacks
			if (typeof settings.onHide === 'function') {
				$dialog.off('hidden.bs.modal').on('hidden.bs.modal', function (e) {
					settings.onHide.call($dialog);
				});
			}
			// Opening dialog
			$dialog.modal();
		},
		/**
		 * Closes dialog
		 */
		hide: function () {
			$dialog.modal('hide');
		}
	};

})(jQuery);

function formataDataString(data) {
    var partesData = data.split('-');
    return partesData[2] + "/" + partesData[1] + "/" + partesData[0];
}

function formataPadraoData(data) {
    var partesData = data.split('/');
    return partesData[1] + "/" + partesData[0] + "/" + partesData[2];
}

function formataTelefone(numero){
    if(numero.substring(0,2) === "55" ){
        if(numero.length === 13){
            return numero.substring(0,2)+"("+numero.substring(2,4)+")"+numero.substring(4,9)+"-"+numero.substring(9);    
        }
        else if(numero.length === 12){
            return numero.substring(0,2)+"("+numero.substring(2,4)+")"+numero.substring(4,8)+"-"+numero.substring(8);    
        }
        else{
            return numero;
        }
        
    }
    else if(numero.substring(0,2) === "31"){
        if(numero.length === 11){
            return "("+numero.substring(0,2)+")"+numero.substring(2,7)+"-"+numero.substring(7);    
        }
        else if (numero.length === 10){
            return "("+numero.substring(0,2)+")"+numero.substring(2,6)+"-"+numero.substring(6);    
        }
        else{
            return numero;
        }
    } 
    else{
        return numero;    
    }
}

function formataMoeda(valor){
    return "R$ " + valor.toFixed(2).replace('.', ',').replace(/(\d)(?=(\d{3})+\,)/g, "$1.");
}

function converteSegundos(numero){
    var hours = parseInt(numero / 3600),
    minutes = parseInt(numero % 3600 / 60),
    seconds = parseInt(numero  % 3600 % 60);
    return (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds  < 10 ? "0" + seconds : seconds);
}

function redirecionar(pagina){    
    if(pagina =='faturas'){
       window.location.href = "faturas.php";
    }
    else if (pagina =='home'){
        window.location.href = "home.php";
    }    
}

//#endregion Funções Gerais

//#region Home
function confirmaLogin() {
    waitingDialog.show();
    var loginUser = $("#usuario").val();
    var passUser = $("#senha").val();
	console.log(_cnpj(loginUser));
	
	if (_cnpj(loginUser)=== true){
		console.log("é cnpj");
		$.ajax({
			method: "POST",
			url: "config/funcoes.php",       
			cache: false,
			datatype: "json",
			data: {
				funcao: "geral",
				login_user: loginUser,
				pass_user: passUser            
			},
			error: function() {
				alert('Erro ao tentar ação!');
				waitingDialog.hide();
			},
			success: function(retorno){
				console.log(retorno)
				if (retorno === "OK") {
					$('#erroAoLogar').hide();
					location.href='home.php'; 
					console.log("passei");					
				}
				else if(retorno === "redireciona"){
					location.href='http://adapter.net.br/CentralAssinante/Vero';
					console.log("passei 1");
				}
				else {
					var msgErro = "Você digitou incorretamente o CPF ou SENHA do titular da assinatura. Por favor, tente novamente.";
					if (retorno !== "") {
						msgErro = "Erro ao buscar os dados! " + retorno;
					}
					$('#erroAoLogar').text(msgErro);
					$('#erroAoLogar').show();
					waitingDialog.hide();
					console.log("passei 2");
				}
				
			}        
		});  
	} else {
		console.log("não é cnpj");
		$.ajax({
			method: "POST",
			url: "config/funcoes.php",       
			cache: false,
			datatype: "json",
			data: {
				funcao: "externo",
				login_user: loginUser,
				pass_user: passUser            
			},
			error: function() {
				alert('Erro ao tentar ação!');
				waitingDialog.hide();
			},
			success: function(retorno){
				console.log(retorno);
				if (retorno === "OK") {
					$('#erroAoLogar').hide();
					location.href="../home.php"; 
					console.log("passei");	
				}
				else if(retorno === "redireciona"){
					location.href='http://adapter.net.br/CentralAssinante/Vero';
					console.log("passei 1");
				}
				else {
					var msgErro = "Você digitou incorretamente o CPF ou SENHA do titular da assinatura. Por favor, tente novamente.";
					if (retorno !== "") {
						msgErro = "Erro ao buscar os dados! " + retorno;
					}
					$('#erroAoLogar').text(msgErro);
					$('#erroAoLogar').show();
					waitingDialog.hide();
					console.log("passei 2");
				}
				
			}        
		});  
	}
    return false;  
}

function verificaFaturaDigital(){
   
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "verificaFaturaDigital"
        },
        error: function(retorno) {
            alert('Erro ao tentar ação!'+ retorno);
           
        },
        success: function(retorno){                 
            if (retorno === "ACCEPTED") {                              
                $('#btnAlteraFaturaDigital').show();                          
            }          
            else {
                $('#btnAlteraFaturaDigital').hide();                 
            }
          
        }        
        
    });  
}
function ConfirmaFaturaDigital(){

    $('#modalAlteraFaturaDigital').modal('show');       
    return false;

}
function AlterarFaturaDigital(){
   
    waitingDialog.show();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "alterarFaturaDigital"
        },
        error: function(retorno) {
            alert('Erro ao tentar ação!'+ retorno);
           waitingDialog.hide();
        },
        success: function(retorno){       
            if (retorno === "OK") {              
                $('#mensagemFaturaDigital').val('');
                $('#mensagemFaturaDigital').text("Sua fatura foi alterada para fatura digital, você receberá um e-mail de confirmação da alteração nos e-mails de contato cadastrados no sistema.");
                $('#modalConfirmacaoAlteracaoFaturaDigital').modal('show');                       
            }                     
            waitingDialog.hide();
        }        
        
    });  
    verificaFaturaDigital();
    return false;  
   
}

function ResetarSenha(){
    var cpfcnpjCliente =  $("#cpfcnpj_user").val();
  
    waitingDialog.show();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "resetarSenha",            
            cpfcnpj_cliente: cpfcnpjCliente 
        },
        error: function(retorno) {
            alert('Erro ao tentar ação!'+ retorno);
           waitingDialog.hide();
        },
        success: function(retorno){       
            var dados = JSON.parse(retorno);            
            if(dados.indexOf('error') !== -1){            
              $('#mensagem').val('');
              $('#mensagem').text("Não foi possível encontrar um cliente com esses dados de acesso!");
            }
            else {
                $('#mensagem').val('');
                $('#mensagem').text("A senha resetada! Foi enviado para o celular cadastrado um SMS com a nova senha!");                      
            }    
            $('#modalSMS').modal('show'); 
            $("#form").show();
            $("#EsqueceSenha").show();
            $("#formResetaSenha").hide();
            
            waitingDialog.hide();               
        }
        
    });  
    return false;  
   
}

function geraConsumoInternet() {
   
    var valorCombo = (document.getElementById("codContratoIndex").value).split("-");
    var codContrato = valorCombo[0];//document.getElementById("codContratoIndex").value;
    var isPrePago = valorCombo[1];
    var instalacao = valorCombo[2];

    if((isPrePago == "false") && (($("#codContratoIndex option:selected").text()).includes("SUSPENSO PARCIALMENTE") == true || ($("#codContratoIndex option:selected").text()).includes("SUSPENSO") == true)){
        $("#btnHabilitarConfianca").show();
    }
    else{
        $("#btnHabilitarConfianca").hide();
    }

    $("#EndInstContrato").text(instalacao);

    waitingDialog.show();
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "totalNavegacao",            
            cod_contrato: codContrato 
        },
        error: function() {
            alert('Erro ao tentar ação!');
            waitingDialog.hide();
        },
        success: function(retorno){
            var dados = JSON.parse(retorno);
            
            if (dados == null || dados.limiteGB == null) {
                $("#semDadosConsumo").show();
                $("#dadosConsumo").hide();
            }
            else {
                $("#semDadosConsumo").hide();
                $("#dadosConsumo").show();

                var navegado = Math.round(dados.navegadoGB * 100) / 100;
                var franquia = parseFloat(dados.limiteGB.replace("GB",""));
                var perConsumido = (navegado * 100) / franquia;
                perConsumido = Math.round(perConsumido * 100) / 100;
                var perDisponivel = Math.round((100 - perConsumido) * 100) / 100;                

                $("#perConsumido").css("width", perConsumido + "%");
                
				if(dados.limiteGB == "0TB"){
					$("#txtConsumido").text(navegado + "GB");
					$("#txtDisponivel").text("ILIMITADO");
				} else {
					$("#txtConsumido").text(navegado + "GB / " + perConsumido + "%");
					$("#txtDisponivel").text(franquia + "GB / " + perDisponivel + "%");
				}
            }

            waitingDialog.hide();
        }
        
    });  

    return false;    
}

function habilitaConfianca(){
    
    waitingDialog.show();
   
    var valorCombo = (document.getElementById("codContratoIndex").value).split("-");
    var codContrato = valorCombo[0];//document.getElementById("codContratoIndex").value;
    var status = "HABILITADO EM CONFIANCA";
  

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "habilitarConfianca",            
            cod_contrato: codContrato,
            status_contrato: status
        },
        error: function(retorno) {
            alert('Erro ao tentar ação!');
            waitingDialog.hide();
        },
        success: function(retorno){            
         var dados = JSON.parse(retorno);
          if(dados['error'] != null){            
            $('#mensagem').val('');
            $('#mensagem').text(dados['error']);
            $('#modalHabilitaConfianca').modal('show');
          }
          else if(dados['success'] != null){      
            var dataFimHabilitacao = moment(new Date(dados['object'])).format("DD/MM/YYYY");            
            $('#mensagem').val('');
            $('#mensagem').text("O Contrato foi habilitado com sucesso! \n Se o pagamento não for realizado até o dia: "+ dataFimHabilitacao +" o serviço será suspenso novamente.");
            $('#modalHabilitaConfianca').modal('show');            
            $.ajax({
                method: "POST",
                url: "classes/funcoes.php",       
                cache: false,
                datatype: "application/pdf",
                data: {
                    funcao: "contratosCliente"
                },
                error: function() {
                    alert('Erro ao tentar ação!');
                },
                success: function(dados){                  
                }
            });           
          }                
          waitingDialog.hide();
        }
        
    }); 
    return false;    

}

function atualiza(){
    location.reload();
}

//#endregion Home

//#region Extrato de Conexão

function geraExtratoConexao(){    
    waitingDialog.show();
    var codContrato = document.getElementById("codContrato").value;
    var visao = document.getElementById("visaoExtrato").value;
    var dataInicial = ($("#dataInicial").find("input").val()).replace(/\//g,'-');
    var dataFinal = ($("#dataFinal").find("input").val()).replace(/\//g,'-');    
    var dadosGrafico = [];

    $('#tblExtratoConexao thead').remove();
    $('#tblExtratoConexao tbody').remove();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "extrato",
            cod_contrato: codContrato,
            data_inicial: dataInicial,
            data_final: dataFinal
        },
        error: function() {
            alert('Erro ao tentar ação!');
            waitingDialog.hide();
        },
        success: function(retorno){
            var dados = JSON.parse(retorno);
            var download = [], upload = [], xValues = [];
            
            
            if ((dados === null) || (dados.length <= 0)) {               
                waitingDialog.hide();
            }
            else {  
                var dadosConsolidados = [];     

                if (visao === "DIA") {

                    $("#tblExtratoConexao").append("<thead>" +
                    "<tr>" +
                    "    <th>Data</th>" +
                    "    <th>Download (GB)</th>" +
                    "    <th>Upload (GB)</th>" +
                    "    <th>Data Coleta</th>" +
                    "</tr>" +
                    "</thead>" +
                    "<tbody></tbody>");

                    for (var i = 0; i < dados.length; i++) {
                        var valDownload = parseFloat((dados[i].download / Math.pow(1024, 3)).toFixed(2));
                        var valUpload = parseFloat((dados[i].upload / Math.pow(1024, 3)).toFixed(2));
                        var data = dados[i].inicioSessao;
                        var dataFormatada = moment(new Date(dados[i].inicioSessao)).format("DD/MM/YYYY HH:mm:ss")
                        var duracao = dados[i].duracaoFormatada;
                        var dataColetaFormatada = moment(new Date(dados[i].dataColeta)).format("DD/MM/YYYY HH:mm:ss")

                        var index = hasDateInArray(dataFormatada, dadosConsolidados);
                        if (index > -1) {                        
                            dadosConsolidados[index].download = Math.round((dadosConsolidados[index].download + valDownload) * 100) / 100;
                            dadosConsolidados[index].upload = Math.round((dadosConsolidados[index].upload + valUpload) * 100) / 100;                   
                        }
                        else {
                            dadosConsolidados.push({data: data, dataFormatada: dataFormatada, download: valDownload, upload: valUpload, duracao: duracao, coleta: dataColetaFormatada});
                        }
                    }

                    for (var i = 0; i < dadosConsolidados.length; i++) {                 
                        download.push({ x : i, y : dadosConsolidados[i].download });
                        upload.push({ x : i, y : dadosConsolidados[i].upload });
                        xValues.push(dadosConsolidados[i].dataFormatada);    
                        
                        /*Criando a tabela*/
                        $("#tblExtratoConexao > tbody").append(
                            "<tr> " +
                            "    <td>" + dadosConsolidados[i].dataFormatada + "</td>" +                        
                            "    <td>" + dadosConsolidados[i].download + "</td>" +
                            "    <td>" + dadosConsolidados[i].upload + "</td>" +  
                            "    <td>" + dadosConsolidados[i].coleta + "</td>" +                   
                            "</tr>"
                        );
                    }    

                    
                }
                else if (visao === "SESSAO") {

                    $("#tblExtratoConexao").append("<thead>" +
                    "<tr>" +
                    "    <th>Início Sessão</th>" +
                    "    <th>Fim Sessão</th>" +
                    "    <th>Duração</th>" +
                    "    <th>Download (GB)</th>" +
                    "    <th>Upload (GB)</th>" +
                    "    <th>Data Coleta</th>" +
                    "</tr>" +
                    "</thead>" +
                    "<tbody></tbody>");

                    for (var i = 0; i < dados.length; i++) {
                        var valDownload = parseFloat((dados[i].download / Math.pow(1024, 3)).toFixed(2));
                        var valUpload = parseFloat((dados[i].upload / Math.pow(1024, 3)).toFixed(2));  
                        var inicioSessao = moment(new Date(dados[i].inicioSessao)).format("DD/MM/YYYY HH:mm:ss");
                        var fimSessao = moment(new Date(dados[i].fimSessao)).format("DD/MM/YYYY HH:mm:ss");
                        var dataColeta = moment(new Date(dados[i].dataColeta)).format("DD/MM/YYYY HH:mm:ss");
                        if (dados[i].fimSessao < dados[i].inicioSessao) {
                            fimSessao = "";
                        }                       
                        var duracao = dados[i].duracaoFormatada;
                        if (duracao == null) {
                            duracao = "";
                        }

                        download.push({ x : i, y : valDownload });
                        upload.push({ x : i, y : valUpload });
                        xValues.push(inicioSessao);  

                        /*Criando a tabela*/
                        $("#tblExtratoConexao > tbody").append(
                            "<tr> " +
                            "    <td>" + inicioSessao + "</td>" +
                            "    <td>" + fimSessao + "</td>" +
                            "    <td>" + duracao + "</td>" +
                            "    <td>" + valDownload + "</td>" +
                            "    <td>" + valUpload + "</td>" +
                            "    <td>" + dataColeta + "</td>" +
                            "</tr>"
                        );
                    }
                }                       
                
                dadosGrafico.push({ key: "Upload (GB)", values: upload, color: "#87C7B7" });
                dadosGrafico.push({ key: "Download (GB)", values: download, color: "#00796A" });
            }

            var height = 400;
        
            nv.addGraph({
                generate: function() {                    
                    var chart = nv.models.lineChart()                
                        .height(height)
                        .noData("Não há dados para exibir.")
                        .margin({top: 50, bottom: 150});
        
                    chart.dispatch.on('renderEnd', function(){
                        waitingDialog.hide();             
                    });                   
        
                    chart.xAxis
                        .rotateLabels(-90)
                        .ticks(xValues.length)                       
                        .tickFormat(function(d) { 
                        return xValues[d];
                    });                     
        
                    var svg = d3.select('#chartExtratoConexao svg').datum(dadosGrafico).style({ 'height': height });;                    
                    svg.transition().duration(0).call(chart);
        
                    return chart;
                },
                callback: function(graph) {
                    nv.utils.windowResize(function() {                                               
                        d3.select('#chartExtratoConexao svg')
                            .attr('width', "100%")                            
                            .transition().duration(0)
                            .call(graph);
                    });                    
                }
            });  
        }
    });    
        
    return false;
}
//#endregion Extrato de Conexão

//#region Atendimentos
function BuscaAtendimentos(){
    var e = document.getElementById("contrato");
    var Codcontrato = e.options[e.selectedIndex].value;

    waitingDialog.show();
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "atendimento",
            cod_contrato: Codcontrato
        },
        error: function() {
            alert('Erro ao tentar ação!');
        },
        success: function(retorno){            
            var dados = JSON.parse(retorno);
            $('#tblAtendimento tbody > tr').remove();
            if(dados['atendimentos'].length > 0){
                for (var it = 0; it < dados['atendimentos'].length; it++) {
                    $("#tblAtendimento > tbody").append(
                        "<tr> <th scope='row'></th>    " +
                        "    <td>#" + dados['atendimentos'][it]['NroProtocolo'] + "</td>" +
                        "    <td>" + dados['atendimentos'][it]['DescricaoProblema'] + "</td>" +
                        "    <td>" + dados['atendimentos'][it]['GerouVisita'] + "</td>" +
                        "    <td>" + dados['atendimentos'][it]['TempoEstimado'] + "</td>" +
                        "    <td>" + dados['atendimentos'][it]['StatusAtend'] + "</td>" +
                        "    <td>" + dados['atendimentos'][it]['DataVisita'] + "</td>" +
                        "    <td>" + formataDataString(dados['atendimentos'][it]['DataAbertura']) + "</td>" +                   
                        "</tr>"
                        );

                }
                waitingDialog.hide();  
            }
            else{
                waitingDialog.hide(); 
                $('#modalAtendimento').modal('show'); 
            }         
        }        
    });

}

function BuscaTipoAtendimento(){
    var e = document.getElementById("contrato");
    var Codcontrato = e.options[e.selectedIndex].value;
   
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "tipoAtendimento",
            cod_contrato: Codcontrato
        },
        error: function() {
            alert('Erro ao tentar ação!');
        },
        success: function(retorno){
            var dados = JSON.parse(retorno);
            document.getElementById("tipoAtendimento").disabled = false;
            $("#tipoAtendimento").empty()
            for (i=0; i< dados.length; i++) {
                document.getElementById("tipoAtendimento").options[i] = new Option(dados[i]['TipoAtendimento'],dados[i]['CodTipoAtendimento'] +"-"+dados[i]['IDDestino']);
            }
        }
    });
    return false;
}

function CriaAtendimento(){
    var id = document.getElementById("contrato");
    var idContrato = id.options[id.selectedIndex].value;
    
    var dado = document.getElementById("tipoAtendimento");
    var TipoCentroCusto = dado.options[dado.selectedIndex].value;

    dados = TipoCentroCusto.split("-");
    var idTipoAtendimento = dados[0];

    var idCentroCusto = dados[1];    
    var status = "PENDENTE"
    var descricao = $('#descricao').val();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "novoAtendimento",
            cod_contrato : idContrato,
            cod_centroCusto: idCentroCusto,
            status_chamado : status,
            cod_atendimento : idTipoAtendimento,
            desc_chamado : descricao
        },
        error: function() {
            alert('Erro ao tentar ação!');
        },
        success: function(retorno){
            if(retorno = "CREATED"){                
               $('#modalChamado').modal('show');
            }
        }
    });

}
//#endregion Atendimentos

//#region Faturas
function BuscaLinhaDigitavel(idFatura){
        waitingDialog.show();
        $.ajax({
            method: "POST",
            url: "classes/funcoes.php",       
            cache: false,
            datatype: "json",
            data: {
                funcao: "linhaDigitavel",
                id_fatura: idFatura
            },
            error: function() {
                alert('Erro ao tentar ação!');
            },
            success: function(retorno){
                waitingDialog.hide();
                var dados = JSON.parse(retorno);
                cdBarra = dados['linhaDigitavel'];
                $('#codigo').text('');
                $('#valor').val('');
                $('#codigo').val(cdBarra);
                $('#valor').val((dados['valor']).toFixed(2));
                $('#modalLinhaDigitavel').modal('show');
                
            }
        }); 
    
   
}

function CopiaLinhaDigitavel(){
    $('#codigo').select();
    document.execCommand("copy");    
}

function BaixaFatura(idFatura){
    var funcao= "faturaPDF";
 
        waitingDialog.show();  
        $.ajax({
           
            method: "POST",
            url: "classes/funcoes.php",       
            cache: false,
            datatype: "application/pdf",
            data: {
                funcao: funcao,
                id_fatura:idFatura
            },
            error: function() {
                alert('Erro ao tentar ação!');
            },
            success: function(dados){
                waitingDialog.hide();
            var blob = new Blob(),
                    downloadLink =  $('#dwnldLnk').append("<a></a>"),
                    nomeArquivo = idFatura+".pdf";
                    downloadLink.attr('href',dados);
                    downloadLink.attr("download", nomeArquivo);
                downloadLink[0].click();
                $.ajax({
                    method: "POST",
                    url: "classes/funcoes.php",       
                    cache: false,
                    datatype: "application/pdf",
                    data: {
                        funcao: "deletePDF",
                        caminho_arquivo: dados,
                    },
                    error: function() {
                        alert('Erro ao tentar ação!');
                    },
                    success: function(dados){                  
                    }
                });    
            }
        });     
    return false;
}
var IDFatura;
function InformaPagamento(NumeroBoleto,valor,vencimento,idFatura){

    IDFatura = idFatura;
    $('#numBoleto').text(NumeroBoleto);
    $('#valorBoleto').text(valor);
    $('#vencimentoBoleto').text(vencimento);
    $('#modalInformaPagamento').modal('show');         
}

function ConfirmaPagamento(){  
    var file_data = $('#sortpicture').prop('files')[0];   
    var form_data = new FormData();                  
    form_data.append('file', file_data); 
    waitingDialog.show();  

    if(file_data !== undefined){
        $.ajax({
        method: "POST",       
        url: "classes/upload.php", 
        datatype: "application/pdf",
        cache: false,
        contentType :false,
        processData: false,
        data: form_data,            
        type: 'post',       
        error: function(retorno) {
            alert('Erro ao tentar ação!');
        },
        success: function(retorno){
            EnviaEmailComprovante(retorno);   
        }
        });
    }  
     
}





function FaturaVencidaMais60Dias(vencimento,valor,nroBoleto) {
	$('#Msg_Fatura_Vencida').html('<p>A fatura '+ nroBoleto +' com vencimento em '+ vencimento +' não pode ser impressa pois já se passaram mais de 59 dias após o vencimento favor entrar em contato com o SAC.</p>');
	$('#modalFaturaVencida').modal('show'); 
}







function EnviaEmailComprovante(caminhoComprovante){   
    var boleto = $('#numBoleto').text();
    var valor = $('#valorBoleto').text();
    var vencimento = $('#vencimentoBoleto').text();
    if(caminhoComprovante != ""){
            var comprovante = caminhoComprovante;
           $.ajax({
                method: "POST",       
                url: "classes/funcoes.php", 
                datatype: "application/pdf",
                cache: false,
                data: {
                    funcao: "informarPagamento",
                    numBoleto : boleto,
                    valor : valor,
                    data_vencimento: vencimento,
                    comprovante: comprovante,
                    id_fatura: IDFatura
                },                                           
                error: function(retorno) {
                    waitingDialog.hide();
                    alert('Erro ao tentar ação!');
                },
                success: function(retorno){
                    waitingDialog.hide();
                   // alert(retorno); // display response from the PHP script, if any
                    $('#modalConfirmaPagamento').modal('show');                       
                }
             });
    }else{
        $.ajax({
            method: "POST",       
            url: "classes/funcoes.php", 
            datatype: "application/pdf",
            cache: false,
            data: {
                funcao: "informarPagamento",
                numBoleto : boleto,
                valor : valor,
                data_vencimento: vencimento
            },                                           
            error: function(retorno) {
                waitingDialog.hide();
                alert('Erro ao tentar ação!');
            },
            success: function(retorno){
                waitingDialog.hide();
               // alert(retorno); // display response from the PHP script, if any
                $('#modalConfirmaPagamento').modal('show');                       
            }
         });
    }
     
}














//#endregion Faturas

//#region Nota Fiscal
var dadosNota;
function BuscaNotaFiscal(){    
    var dataInicial =($("#dataInicial").find("input").val()).replace(/\//g,'-');
    var dataFinal = ($("#dataFinal").find("input").val()).replace(/\//g,'-');    
    var qteNotas = 0;
    
    waitingDialog.show();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "notasFiscais",
            data_inicial: dataInicial,
            data_final: dataFinal
        },
        error: function() {
            alert('Erro ao tentar ação!');
        },
        success: function(retorno){ 
            waitingDialog.hide();             
            dadosNota = JSON.parse(retorno);            
            $('#tblNotas tbody > tr').remove();
            if(dadosNota.length > 0){               
                for (var it = 0; it < dadosNota.length; it++) {
                    var dataEmissao = moment(new Date(dadosNota[it]['dataEmissao']));                    
                        $("#tblNotas > tbody").append(
                            "<tr> <th scope='row'></th>    " +
                            "    <td>#" + dadosNota[it]['numeroNF'] + "</td>" +
                            "    <td>" + dadosNota[it]['descricaoModelo'] + "</td>" +
                            "    <td>" + moment(new Date(dadosNota[it]['dataEmissao'])).format("DD/MM/YYYY") + "</td>" +
                            "    <td>" + dadosNota[it]['valor'] + "</td>" +
                            "    <td>" + moment(new Date(dadosNota[it]['vencimento'])).format("DD/MM/YYYY") + "</td>" + 
                            "    <td> <a class='btn btn-success' title='Baixar Nota' onclick='BaixaNotaFiscal("+dadosNota[it]['id']+")'><span class='glyphicon glyphicon glyphicon-download' aria-hidden='true'></span></a>"+ "</td>" +                                                        
                            "</tr>"
                            );
                            qteNotas++;                     
                }               
            } 
                 
            if(qteNotas >0){
                $('#SemNotas').hide();
                $('#QteNotas').show();
                $('#TotalNotas').text(qteNotas);
            }   
            else{
                $('#QteNotas').hide();
                $('#SemNotas').show();
            }                     
        } 
    });
    return false;
         
}
function BaixaNotaFiscal(idNotaFiscal){
    waitingDialog.show();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "application/pdf",
        data: {
            funcao: "notasFiscaisPDF",
            id_notaFiscal:idNotaFiscal
        },
        error: function() {
            alert('Erro ao tentar ação!');
        },
        success: function(dados){
            waitingDialog.hide();  
          var blob = new Blob(),
                downloadLink =  $('#dwnldLnk1').append("<a></a>"),
                dataAtual = new Date(),
                nomeArquivo = idNotaFiscal+".pdf";
                downloadLink.attr('href',dados);
                downloadLink.attr("download", nomeArquivo);
            downloadLink[0].click(); 
            $.ajax({
                method: "POST",
                url: "classes/funcoes.php",       
                cache: false,
                datatype: "application/pdf",
                data: {
                    funcao: "deletePDF",
                    caminho_arquivo: dados,
                },
                error: function() {
                    alert('Erro ao tentar ação!');
                },
                success: function(dados){                  
                }
            });               
        }
    });  
}
//#endregion Nota Fiscal

//#region Extrato Ligação
function geraExtratoLigacao(){    
    waitingDialog.show();
    var codContrato = document.getElementById("codContrato").value;
    var dataInicial = ($("#dataInicial").find("input").val()).replace(/\//g,'-');
    var dataFinal = ($("#dataFinal").find("input").val()).replace(/\//g,'-');    

    if(codContrato != "")
    {
        $.ajax({
            method: "POST",
            url: "classes/funcoes.php",       
            cache: false,
            datatype: "json",
            data: {
                funcao: "extratoLigacao",
                cod_contrato: codContrato,
                data_inicial: dataInicial,
                data_final: dataFinal

            },
            error: function() {
                alert('Erro ao tentar ação!');
            },
            success: function(retorno){    
                var dados = JSON.parse(retorno);
                if (dados === null) {               
                    waitingDialog.hide();
                }
                else {          
                $('#tblExtratoLigacao tbody > tr').remove();
                for (var it = 0; it < dados.length; it++) {
                        $("#tblExtratoLigacao > tbody").append(
                            "<tr> <th scope='row'></th>    " +
                            "    <td>" + moment(new Date(dados[it]['dataLigacao'])).format("DD/MM/YYYY HH:mm:ss") + "</td>" +
                            "    <td>" + formataTelefone(dados[it]['origem']) + "</td>" +
                            "    <td>" + formataTelefone(dados[it]['destino']) + "</td>" +
                            "    <td>" + converteSegundos(dados[it]['duracao']) + "</td>" +
                            "    <td>" + formataMoeda(dados[it]['valor']) + "</td>" +
                            "    <td>" + dados[it]['descricaoTipoLigacao'] + "</td>" +                                  
                            "</tr>"
                            );

                    }
                    
                }               
            }         
        });
        
    }
    waitingDialog.hide(); 
    return false;
    
}
//#endregion Extrato Ligação

//#region Perfil
function EditarPerfil(qteContratos, idCliente){
    var contratosCliente= [];
    var dadosCliente = [];
    var valorCombo = (document.getElementById("codContratoIndex").value);
   

    for (var it = 0; it < qteContratos; it++) {
        contratosCliente.push({        
            'Plano': $('#Plano'+it).val(),
            'CodContrato': $('#CodContrato'+it).val(),
            'TipoEndereco': $('#TipoEndereco'+it).val(),
            'TipoLogradouro': $('#TipoLogradouro'+it).val(),
            'Logradouro': $('#Logradouro'+it).val(),
            'Numero': $('#Numero'+it).val(),
            'Complemento': $('#Complemento'+it).val(),
            'Bairro': $('#Bairro'+it).val(),
            'Cidade': $('#Cidade'+it).val(),
        });
    }

    dadosCliente = { 
        'IDCliente': idCliente,
        'NomeCompleto': $('#nome').val(),
        'RG': $('#documentoRG').val(),
        'DataNascimento': ($("#dataNascimento").find("input").val()).replace(/\//g,'-'),
        'Email': $('#email').val(),
        'TelefoneFixo': $('#telefoneFixo').val(),
        'Celular': $('#celular').val(),
        'Telefone1': $('#telefone1').val(),
        'Telefone2': $('#telefone2').val(),
        'Contratos': contratosCliente
    }; 
   var dados = JSON.stringify(dadosCliente);
   
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
                funcao: "alterarPerfil",
                dadosPerfil: dados       
              },
              error: function() {
                  alert('Erro ao tentar ação!');
              },
              success: function(retorno){ 
                $('#mensagem').val('');
                $('#mensagem').text(retorno);
                $('#modalEditarPerfil').modal('show');
              }
    });
    
}

function EditaEndereco () {
   
    var exibirTodos = $("#ExibeTodos").is(':checked');//Retornar true ou false alert("CheckBox marcado."); else alert("CheckBox desmarcado."); });


    var valorCombo = (document.getElementById("codContratoIndex").value);
    if(exibirTodos){
        $("[name='Enderecos']").show();
        $("[name='PlanoContrato']").show();
        $('#codContratoIndex').prop("disabled", true);
    }
    else{
        $("[name='Enderecos']").hide(); 
        $("[name='PlanoContrato']").hide();
        $('#codContratoIndex').prop("disabled", false);
            // $("#"+valorCombo).show();                               
        $("#formulario").children().each(function() {
                //$("#"+valorCombo).show();
                if($("#"+valorCombo).attr('id') == valorCombo){
                    $("#"+valorCombo).show();
                }
            });
    }
};  

//#endRegion Perfil

//#region Alterar Senha
function redefinirSenha(){    
    var senhaAtual =  $("#senhaAtual").val();
    var novaSenha =  $("#novaSenha").val();
    var novaSenha2 =  $("#novaSenha2").val();

    
    waitingDialog.show();

    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "redefinirSenha",            
            senhaAtual: senhaAtual,
            novaSenha: novaSenha,
            novaSenha2: novaSenha2
        },
        error: function(retorno) {
            alert('Erro ao tentar ação!'+ retorno);
            waitingDialog.hide();
        },
        success: function(retorno){       
           var dados = JSON.parse(retorno);    
           $('#senhaAtual').removeAttr('data-match')
                                .removeAttr('data-match-error');     
           $('#f1').validator('validate');       
            if(dados.indexOf('erroSenhaAtual') !== -1){ 
                waitingDialog.hide(); 
             $('#senhaAtual').attr('data-match','true')
                             .attr('data-match-error','Senha atual digitada, diferente da senha cadastrada!');  
             $('#f1').validator('validate');
            }else if(dados.indexOf('success') !== -1){
                waitingDialog.hide();
                $('#mensagem').val('');
                $('#mensagem').text("Senha redefinida com sucesso!!  Faça login novamente para que as alterações sejam aplicadas!");
                $('#modalRedefinirSenha').modal('show');                           
            }else if (dados.indexOf('error') !== -1){
                waitingDialog.hide();
                $('#mensagem').val('');
                $('#mensagem').text("Ocorreu um erro ao processar a solicitação! Tente novamente mais tarde!");
                $('#modalRedefinirSenha').modal('show');                           
            }
            waitingDialog.hide();           
        }                               
        
    });  
    return false;     
}
function logout(){
    var msg =  $('#mensagem').text();
    if(msg.indexOf('erro') !== -1){
        close();
    }else{
        window.location.href = "logout.php";
    }    
}
//#endRegion Alterar Senha

//#Region DDA
function BaixaDDA(anoReferencia,codCliente){
   
    waitingDialog.show();
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "json",
        data: {
            funcao: "validaDDA",            
            anoReferencia: anoReferencia
        },
        error: function(retorno) {
            alert('Erro ao tentar ação!'+ retorno);
            waitingDialog.hide();
        },
        success: function(retorno){ 
           var dados = JSON.parse(retorno);                    
           if(dados.indexOf('error') !== -1){
                waitingDialog.hide();
                $('#mensagem').val('');
                $('#mensagem').text("Existem débitos em aberto para o período selecionado! Entre em contato com o financeiro para realizar a regularização");
                $('#modalDDA').modal('show');                           
            }else if (dados.indexOf('success') !== -1){
                $.ajax({
                    method: "POST",
                    url: "classes/funcoes.php",       
                    cache: false,
                    datatype: "application/pdf",
                    data: {
                        funcao: "baixaDDA",
                        anoReferencia: anoReferencia
                    },
                    error: function() {
                        alert('Erro ao tentar ação!');
                    },
                    success: function(dados){
                        waitingDialog.hide();
                      var blob = new Blob(),
                            downloadLink =  $('#dwnldLnk').append("<a></a>"),
                            dataAtual = new Date(),
                            nomeArquivo = "quitacao_anual_"+codCliente+".pdf";
                            downloadLink.attr('href',dados);
                            downloadLink.attr("download", nomeArquivo);
                        downloadLink[0].click();
                        $.ajax({
                            method: "POST",
                            url: "classes/funcoes.php",       
                            cache: false,
                            datatype: "application/pdf",
                            data: {
                                funcao: "deletePDF",
                                caminho_arquivo: dados,
                            },
                            error: function() {
                                alert('Erro ao tentar ação!');
                            },
                            success: function(dados){                  
                            }
                        });    
                    }
                });                   
            }          
        }                                                     
        
    });  
}  

//#endRegion DDA

//#Region Alteração de Vencimento
function verificarVencimentoAlterado(vencimentoAtual,i){

    var vencimento = vencimentoAtual.split('-');


    waitingDialog.show();
    
    if(i<vencimento.length){
        $.ajax({
            method: "POST",
            url: "classes/funcoes.php",       
            cache: false,
            datatype: "json",
            data: {
                funcao: "verificaAlteracaoVencimento",
                vencimento_atual: vencimento[i]
            },
            error: function(retorno) {
                alert('Erro ao tentar ação!'+ retorno);
                waitingDialog.hide();           
               
            },
            success: function(retorno){                                    
                if (retorno === "ACCEPTED") {                                  
                    $("#painel"+vencimento[i]).addClass("panel panel-success");                                                 
                }          
                else {
                    $("#painel"+vencimento[i]).addClass("panel panel-danger");                   
                    $("#cmb"+vencimento[i]).prop("disabled", true);   
                    $("#btn"+vencimento[i]).prop("disabled", true); 
                    $("#informacao"+vencimento[i]).text("*** Já foi solicitada a alteração dos contratos deste vencimento");       
                    $("#informacao"+vencimento[i]).css('font-style','italic');               
                }  
                i = i+1;
                verificarVencimentoAlterado(vencimentoAtual,i);
           
            }                
        });
    }else{
        waitingDialog.hide();
    }
   
}

var vencimentoAtual;
var vencimentoNovo;
function ConfirmaAlteracaoVencimento(idvencimentoAtual,diaVencimentoAtual){
      
    waitingDialog.show();
  
    vencimentoAtual= idvencimentoAtual;   
    var idVencimentoNovo = parseInt((document.getElementById("cmb"+idvencimentoAtual).value));
    vencimentoNovo = idVencimentoNovo;
    var diaNovoVencimento =document.getElementById("cmb"+idvencimentoAtual).options[document.getElementById("cmb"+idvencimentoAtual).selectedIndex].text;
    
    if(vencimentoAtual == idVencimentoNovo){
        $('#mensagemAlerta').val('');
        $('#mensagemAlerta').text("O Vencimento atual e o selecionados precisam ser diferentes!");
        $('#modalAlertaAlteraVencimento').modal('show'); 
           
    }
    else if(idVencimentoNovo ==0){
        $('#mensagemAlerta').val('');
        $('#mensagemAlerta').text("É necessário a escolha de uma novo dia para vencimento!");
        $('#modalAlertaAlteraVencimento').modal('show');         
    }
    else{
        $('#diaVencimentoAtual').text(diaVencimentoAtual);
        $('#diaNovoVencimento').text(diaNovoVencimento);  
        $('#modalConfirmaAlteraVencimento').modal('show');       
    } 
    waitingDialog.hide();          
}

function AlterarVencimento(){
    waitingDialog.show();
  
          $.ajax({
            method: "POST",
            url: "classes/funcoes.php",       
            cache: false,
            datatype: "json",
            data: {
                    funcao: "alterarVencimento",
                    vencimento_atual: vencimentoAtual,
                    vencimento_novo: vencimentoNovo       
                  },
                  error: function() {
                      alert('Erro ao tentar ação!');
                  },
                  success: function(retorno){ 
                    if(retorno=="OK"){
                        $('#mensagemAlteraVencimento').val('');
                        $('#mensagemAlteraVencimento').text("Seu vencimento foi alterado para um novo dia, você receberá um e-mail de confirmação da alteração nos e-mails de contato cadastrados no sistema!");
                        $('#modalAlteraVencimento').modal('show');                             
                    }  
                    waitingDialog.hide();    
            }                     
                 
        });
    
}
function AtualizaBuscaContratos(){
    waitingDialog.show();  
    $.ajax({
        method: "POST",
        url: "classes/funcoes.php",       
        cache: false,
        datatype: "application/pdf",
        data: {
            funcao: "contratosCliente"
        },
        error: function() {
            alert('Erro ao tentar ação!');
        },
        success: function(dados){    
            atualiza();  
            waitingDialog.hide();                                
        }
    });  
        
   
}
//#endRegion Alteração de Vencimento


function _cnpj(cnpj) {

    cnpj = cnpj.replace(/[^\d]+/g, '');

    if (cnpj == '') return false;

    if (cnpj.length != 14)
        return false;

 
    if (cnpj == "00000000000000" ||
        cnpj == "11111111111111" ||
        cnpj == "22222222222222" ||
        cnpj == "33333333333333" ||
        cnpj == "44444444444444" ||
        cnpj == "55555555555555" ||
        cnpj == "66666666666666" ||
        cnpj == "77777777777777" ||
        cnpj == "88888888888888" ||
        cnpj == "99999999999999")
        return false;

 
    tamanho = cnpj.length - 2
    numeros = cnpj.substring(0, tamanho);
    digitos = cnpj.substring(tamanho);
    soma = 0;
    pos = tamanho - 7;
    for (i = tamanho; i >= 1; i--) {
        soma += numeros.charAt(tamanho - i) * pos--;
        if (pos < 2)
            pos = 9;
    }
    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
    if (resultado != digitos.charAt(0)) return false;
    tamanho = tamanho + 1;
    numeros = cnpj.substring(0, tamanho);
    soma = 0;
    pos = tamanho - 7;
    for (i = tamanho; i >= 1; i--) {
        soma += numeros.charAt(tamanho - i) * pos--;
        if (pos < 2)
            pos = 9;
    }
    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
    if (resultado != digitos.charAt(1))
        return false;

    return true;

}