$("#CNPJ").mask("99.999.999/9999-99");
$("#TELEFONE")
  .mask("(99) 9?9999-9999")
  .focusout(function(event) {
    var target, phone, element;
    target = (event.currentTarget) ? event.currentTarget : event.srcElement;
    phone = target.value.replace(/\D/g, '');
    element = $(target);
    element.unmask();
    if (phone.length > 10) {
      element.mask("(99) 99999-999?9");
    } else {
      element.mask("(99) 9999-9999?9");
    }
  });

function getErroCNPJ() {
  var TITULO = '<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Erro!';
  var TEXT_ERROR = '' +
    '<b><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> ATENÇÃO!</b> ' +
    'Não é possivel prosseguir com a atualização da empresa pois o CNPJ  informado não passou no teste de validação do sistema tente novamente ou entre em contato com o ' +
    'administrador do sistema.<br><br><b>Detalhes do erro:</b><br>';
  var ERRO = '<ul><li>O CNPJ ' + $('#CNPJ').val() + ' é inválido.</li></ul>';
  $("#TituloModal").html(TITULO);
  $("#TextError").html(TEXT_ERROR);
  $("#descError").html("<b><i> " + ERRO + " </i></b>");
  $("#Erro").modal('show');
}

function isCNPJValid() {
  var cnpj = $('#CNPJ').val();
  cnpj = cnpj.replace(/[^\d]+/g, '');
  if (cnpj == '') return false;
  if (cnpj.length != 14)
    return false;
  // Elimina CNPJs invalidos conhecidos
  if (cnpj == "00000000000000" || cnpj == "11111111111111" || cnpj == "22222222222222" || cnpj == "33333333333333" || cnpj == "44444444444444" ||
    cnpj == "55555555555555" || cnpj == "66666666666666" || cnpj == "77777777777777" || cnpj == "88888888888888" || cnpj == "99999999999999") {
    getErroCNPJ();
    return false;
  }
  tamanho = cnpj.length - 2
  numeros = cnpj.substring(0, tamanho);
  digitos = cnpj.substring(tamanho);
  soma = 0;
  pos = tamanho - 7;
  for (i = tamanho; i >= 1; i--) {
    soma += numeros.charAt(tamanho - i) * pos--;
    if (pos < 2)
      pos = 9;
  }
  resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
  if (resultado != digitos.charAt(0)) {
    getErroCNPJ();
    return false;
  }
  tamanho = tamanho + 1;
  numeros = cnpj.substring(0, tamanho);
  soma = 0;
  pos = tamanho - 7;
  for (i = tamanho; i >= 1; i--) {
    soma += numeros.charAt(tamanho - i) * pos--;
    if (pos < 2)
      pos = 9;
  }
  resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
  if (resultado != digitos.charAt(1)) {
    getErroCNPJ();
    return false;
  }
  return true;
}
